import java.lang.*;
import java.util.*;

public class RunFiniteStates 
{	
	Vector CurrentFiniteStates = new Vector(); 
	int vectorSize = 0;
   	
	public static void main(String[] args)
	{
		int numStates;
		if (args.length > 0)
		{
			numStates = new Integer(args[0]).intValue();
		}
		else
		{
			numStates = new Random().nextInt(10);
		}
		
		RunFiniteStates runEm = new RunFiniteStates();
		runEm.generateStates(numStates);	
		runEm.rankStates();
		runEm.evolveStates();
	}
	
	public void rankStates()
	{
		for (int i = 0; i < vectorSize; i++)	
		{
			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i)).playMachine(0,0));
		}
	}
	
	public void evolveStates()
	{
		for (int i = 0; i < (vectorSize - 1); i=i+2)
		{
			System.out.println();
			String parent1 = ((FiniteStates) CurrentFiniteStates.elementAt(i)).toString();
			String parent2 = ((FiniteStates) CurrentFiniteStates.elementAt(i+1)).toString();
			String child = parent1.substring(0,parent1.length()/2) + parent2.substring(parent2.length()/2,parent2.length());

			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i)).playMachine(0,0));
			System.out.println(((FiniteStates) CurrentFiniteStates.elementAt(i+1)).toString() + " " + ((FiniteStates) CurrentFiniteStates.elementAt(i+1)).playMachine(0,0));
			FiniteStates childFiniteStates = new FiniteStates(child);

			System.out.println(childFiniteStates.toString() + " " + childFiniteStates.playMachine(0,0));
			System.out.println();

			// Does this system of evolution maintain the good traits?
		}
		
	}
	
	public void generateStates(int numStates)
	{
		Random theRanGen = new Random();

		// 5 States
		for (int p = 0; p < numStates; p++)
		{
			StringBuffer theRanString = new StringBuffer();
			
			// 10 Machines
			for (int i = 0; i < 10; i++)
			{
				// Object
				theRanString.append(theRanGen.nextInt(10));
				
				// State One Next Object Index
				theRanString.append(theRanGen.nextInt(10));
				// State One Next Object State
				theRanString.append(theRanGen.nextInt(2));
				
				// State Two Next Object Index
				theRanString.append(theRanGen.nextInt(10));
				// State Two Next Object State
				theRanString.append(theRanGen.nextInt(2));				
			}

			String theString = theRanString.toString();				
			
			FiniteStates theFiniteStates = new FiniteStates(theString);
			//System.out.println(theFiniteStates.playMachine(0,0));
			
			CurrentFiniteStates.add(theFiniteStates);
			vectorSize++;
		}
	}						
}